<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? htmlspecialchars($pageTitle) . ' - ' : ''; ?><?php echo htmlspecialchars($siteConfig['title']); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($siteConfig['description']); ?>">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background-color: #ffffff;
            color: #333333;
            line-height: 1.6;
        }

        header {
            background-color: #6c3fb5;
            color: white;
            padding: 20px 0;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .header-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo {
            font-size: 24px;
            font-weight: bold;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .logo-icon {
            width: 40px;
            height: 40px;
            background-color: rgba(255, 255, 255, 0.2);
            border-radius: 4px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }

        .status-link {
            color: white;
            text-decoration: none;
            font-size: 14px;
            opacity: 0.9;
            transition: opacity 0.2s;
        }

        .status-link:hover {
            opacity: 1;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            min-height: calc(100vh - 80px);
        }

        .sidebar {
            width: 250px;
            background-color: #f8f8f8;
            border-right: 1px solid #e0e0e0;
            padding: 20px 0;
            overflow-y: auto;
        }

        .sidebar-section {
            margin-bottom: 30px;
        }

        .sidebar-section-title {
            padding: 10px 20px;
            font-weight: bold;
            color: #666;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .sidebar-menu {
            list-style: none;
        }

        .sidebar-menu li {
            margin: 0;
        }

        .sidebar-menu a {
            display: block;
            padding: 12px 20px;
            color: #333;
            text-decoration: none;
            transition: all 0.2s;
            border-left: 3px solid transparent;
            font-size: 14px;
        }

        .sidebar-menu a:hover {
            background-color: #efefef;
            border-left-color: #6c3fb5;
            color: #6c3fb5;
        }

        .sidebar-menu a.active {
            background-color: #e8e0f0;
            border-left-color: #6c3fb5;
            color: #6c3fb5;
            font-weight: 600;
        }

        .sidebar-menu .new-badge {
            display: inline-block;
            background-color: #ff6b6b;
            color: white;
            font-size: 10px;
            padding: 2px 6px;
            border-radius: 3px;
            margin-left: 8px;
            font-weight: bold;
        }

        .main-content {
            flex: 1;
            padding: 40px;
            overflow-y: auto;
        }

        .search-box {
            margin-bottom: 30px;
            display: flex;
            gap: 10px;
        }

        .search-box input {
            flex: 1;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }

        .search-box button {
            padding: 10px 20px;
            background-color: #6c3fb5;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            transition: background-color 0.2s;
        }

        .search-box button:hover {
            background-color: #5a2f95;
        }

        h1 {
            font-size: 32px;
            margin-bottom: 20px;
            color: #1a1a1a;
        }

        h2 {
            font-size: 24px;
            margin-top: 30px;
            margin-bottom: 15px;
            color: #1a1a1a;
            border-bottom: 2px solid #6c3fb5;
            padding-bottom: 10px;
        }

        h3 {
            font-size: 18px;
            margin-top: 20px;
            margin-bottom: 10px;
            color: #333;
        }

        h4 {
            font-size: 16px;
            margin-top: 15px;
            margin-bottom: 8px;
            color: #555;
        }

        p {
            margin-bottom: 15px;
            line-height: 1.8;
        }

        code {
            background-color: #f5f5f5;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            font-size: 13px;
            color: #d63384;
        }

        pre {
            background-color: #2d2d2d;
            color: #f8f8f2;
            padding: 15px;
            border-radius: 4px;
            overflow-x: auto;
            margin: 15px 0;
            font-family: 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.5;
        }

        pre code {
            background-color: transparent;
            color: #f8f8f2;
            padding: 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            border: 1px solid #ddd;
        }

        th {
            background-color: #f0f0f0;
            padding: 12px;
            text-align: left;
            font-weight: 600;
            border-bottom: 2px solid #ddd;
        }

        td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
        }

        tr:hover {
            background-color: #f9f9f9;
        }

        .alert {
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
            border-left: 4px solid;
        }

        .alert-warning {
            background-color: #fff3cd;
            border-left-color: #ffc107;
            color: #856404;
        }

        .alert-info {
            background-color: #d1ecf1;
            border-left-color: #17a2b8;
            color: #0c5460;
        }

        .alert-success {
            background-color: #d4edda;
            border-left-color: #28a745;
            color: #155724;
        }

        .command-box {
            background-color: #f8f9fa;
            border: 1px solid #dee2e6;
            padding: 15px;
            border-radius: 4px;
            margin: 15px 0;
            font-family: 'Courier New', monospace;
            font-size: 13px;
            overflow-x: auto;
        }

        .command-box.dark {
            background-color: #2d2d2d;
            color: #f8f8f2;
            border-color: #444;
        }

        .back-link {
            display: inline-block;
            margin-bottom: 20px;
            color: #6c3fb5;
            text-decoration: none;
            font-size: 14px;
        }

        .back-link:hover {
            text-decoration: underline;
        }

        footer {
            background-color: #f8f8f8;
            border-top: 1px solid #e0e0e0;
            padding: 20px;
            text-align: center;
            color: #666;
            font-size: 13px;
            margin-top: 40px;
        }

        .breadcrumb {
            margin-bottom: 20px;
            font-size: 13px;
            color: #666;
        }

        .breadcrumb a {
            color: #6c3fb5;
            text-decoration: none;
        }

        .breadcrumb a:hover {
            text-decoration: underline;
        }

        .breadcrumb span {
            margin: 0 5px;
        }

        .highlight {
            background-color: #fffacd;
            padding: 2px 4px;
            border-radius: 2px;
        }

        ul, ol {
            margin-left: 20px;
            margin-bottom: 15px;
        }

        li {
            margin-bottom: 8px;
        }

        @media (max-width: 768px) {
            .container {
                flex-direction: column;
            }

            .sidebar {
                width: 100%;
                border-right: none;
                border-bottom: 1px solid #e0e0e0;
                max-height: 300px;
            }

            .main-content {
                padding: 20px;
            }

            h1 {
                font-size: 24px;
            }

            h2 {
                font-size: 20px;
            }
        }
    </style>
</head>
<body>
    <header>
        <div class="header-container">
            <div class="logo">
                <div class="logo-icon">RC</div>
                <span>RC Licensing</span>
            </div>
            <a href="https://status.license.cheap" class="status-link" target="_blank">status.License.Cheap</a>
        </div>
    </header>

    <div class="container">
        <aside class="sidebar">
            <?php foreach ($navigationMenu as $section): ?>
                <div class="sidebar-section">
                    <div class="sidebar-section-title"><?php echo htmlspecialchars($section['label']); ?></div>
                    <ul class="sidebar-menu">
                        <?php foreach ($section['items'] as $item): ?>
                            <li>
                                <a href="?page=<?php echo htmlspecialchars($item['id']); ?>" 
                                   class="<?php echo (isset($_GET['page']) && $_GET['page'] === $item['id']) ? 'active' : ''; ?>">
                                    <?php echo htmlspecialchars($item['label']); ?>
                                    <?php if (strpos($item['label'], 'NEW') !== false): ?>
                                        <span class="new-badge">NEW</span>
                                    <?php endif; ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endforeach; ?>
            <div class="sidebar-section">
                <ul class="sidebar-menu">
                    <li><a href="https://license.cheap" target="_blank">← Back to website</a></li>
                </ul>
            </div>
        </aside>

        <main class="main-content">
