<?php
/**
 * RC Licensing System - Documentation Portal
 * Main entry point
 */

// Include configuration
require_once '../includes/config.php';

// Get the requested page
$page = isset($_GET['page']) ? $_GET['page'] : 'welcome';

// Sanitize page name to prevent directory traversal
$page = preg_replace('/[^a-z0-9\-_]/', '', $page);

// Map page IDs to files
$pageMap = [];
foreach ($navigationMenu as $section) {
    foreach ($section['items'] as $item) {
        $pageMap[$item['id']] = $item['file'];
    }
}

// Determine which page file to load
$pageFile = isset($pageMap[$page]) ? $pageMap[$page] : 'welcome.php';

// Verify file exists before including
$filePath = __DIR__ . '/' . $pageFile;

if (!file_exists($filePath)) {
    // Default to welcome page if file not found
    $pageFile = 'welcome.php';
    $filePath = __DIR__ . '/' . $pageFile;
}

// Include the page
if (file_exists($filePath)) {
    include $filePath;
} else {
    // Fallback - show error
    include '../includes/config.php';
    include '../includes/header.php';
    ?>
    <h1>Page Not Found</h1>
    <p>The requested page could not be found.</p>
    <p><a href="?page=welcome">Return to Welcome Page</a></p>
    <?php
    include '../includes/footer.php';
}
?>
