<?php
$pageTitle = 'Installation';
include '../includes/config.php';
include '../includes/header.php';
?>

<h1>License Installation</h1>

<p>We have released license installer version 3.0. It's supported on all operating systems.</p>

<div class="alert alert-warning">
    <strong>Important:</strong> Be sure to run installer script at root level.
</div>

<h2>Installation Procedure</h2>

<h3>First, make sure you have a valid license from us</h3>

<h4>License Types:</h4>
<table>
    <thead>
        <tr>
            <th>License Type</th>
            <th>Description</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><strong>Trial</strong></td>
            <td>You can request a trial license from 3 to 7 days. Trial licenses have no limit and are similar to paid licenses. Support is enabled on this type of license as well.</td>
        </tr>
        <tr>
            <td><strong>Purchased License</strong></td>
            <td>You have full access to our licensing system + Free support. There are no limitations on paid licenses.</td>
        </tr>
    </tbody>
</table>

<h3>Removing Previous License Installation</h3>
<p>If you have previously installed another license on your server, use this command to remove it:</p>
<pre><code>wget -O remover <?php echo htmlspecialchars($mirrorUrl); ?>/remover; chmod +x remover; ./remover</code></pre>

<h2>Full Installation Commands</h2>

<p>Install your license with one command installation script:</p>

<?php foreach ($licenseTypes as $type => $info): ?>
    <h3><?php echo htmlspecialchars($info['description']); ?></h3>
    
    <h4>Installation:</h4>
    <pre><code>bash &lt;( curl <?php echo htmlspecialchars($mirrorUrl); ?>/pre.sh ) <?php echo htmlspecialchars($info['script']); ?>; <?php echo htmlspecialchars($info['prefix']); ?></code></pre>
    
    <h4>Update:</h4>
    <p>To update your license just run:</p>
    <pre><code><?php echo htmlspecialchars($info['prefix']); ?></code></pre>
    
    <?php if ($type === 'cPanel'): ?>
        <h4>Verification (cPanel only):</h4>
        <p>To get a verification at verify.cpanel.net (To avoid any datacenter abuse report) run:</p>
        <pre><code>touch /etc/.verifylicense ; <?php echo htmlspecialchars($info['prefix']); ?></code></pre>
    <?php endif; ?>
    
<?php endforeach; ?>

<h2>FleetSSL License</h2>
<p>FleetSSL license comes free with cPanel license. Once you have installed cPanel licensing system, run the following command to activate FleetSSL:</p>
<pre><code><?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?> -fleetssl</code></pre>

<h2>WHMCS Integration</h2>
<p>The WHMCS License file was updated on: <strong>2025/05/19</strong>. Make sure your current file is not older than this date.</p>

<p>Download License.php file from the provided link and replace it with <code>YOUR-WHMCS-PATH/vendor/whmcs/whmcs-foundation/lib/License.php</code></p>

<p>If you need the latest WHMCS installation file please contact us.</p>

<h2>Verify Installation</h2>
<p>After you have run the installer script you will see a similar message:</p>

<pre><code>Start downloading primary system...Depending on the speed of your server network, it may take some time ... Completed!
Installing cPanel licensing system ...

 ---------------------- Licensing System started ----------------------
        Thank you for using ResellerCenter.ir licensing system !
 ----------------------------------------------------------------------

Website : ResellerCenter.ir
Server IP : 1.1.1.1
Hostname : client.host.name
cPanel version : 11.100.0.8
kernel version : 3.10.0-1160.49.1.el7.x86_64

 If you have any question connect us on our website.
Copyright 2017-2022 ResellerCenter.ir - All rights reserved.
 ----------------------------------------------------------------------
Today : 2022/02/07
License Expire : LIFE-TIME-LICENSE

Updating local license info...

cPanel license status : OK
cPanel licensing system has been installed. Enjoy</code></pre>

<?php include '../includes/footer.php'; ?>
