<?php
$pageTitle = 'License Commands';
include '../includes/config.php';
include '../includes/header.php';
?>

<h1>What's My License Commands</h1>

<h2>Overview</h2>
<p>This page provides a quick reference for all license commands available in the RC Licensing System. Each license type has its own command prefix for management and updates.</p>

<h2>License Command Reference</h2>

<h3>Command Structure</h3>
<p>All license commands follow this pattern:</p>
<pre><code>PREFIX [options]</code></pre>

<h3>Common Options</h3>

<table>
    <thead>
        <tr>
            <th>Option</th>
            <th>Description</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>No option</td>
            <td>Display license status and update</td>
        </tr>
        <tr>
            <td>-status</td>
            <td>Show current license status</td>
        </tr>
        <tr>
            <td>-version</td>
            <td>Display version information</td>
        </tr>
        <tr>
            <td>-help</td>
            <td>Show help information</td>
        </tr>
        <tr>
            <td>-force</td>
            <td>Force update/reinstall</td>
        </tr>
    </tbody>
</table>

<h2>All License Commands</h2>

<?php foreach ($licenseTypes as $type => $info): ?>
    <h3><?php echo htmlspecialchars($info['description']); ?></h3>
    
    <h4>Command Prefix:</h4>
    <pre><code><?php echo htmlspecialchars($info['prefix']); ?></code></pre>
    
    <h4>Installation:</h4>
    <pre><code>bash &lt;( curl <?php echo htmlspecialchars($mirrorUrl); ?>/pre.sh ) <?php echo htmlspecialchars($info['script']); ?>; <?php echo htmlspecialchars($info['prefix']); ?></code></pre>
    
    <h4>Update License:</h4>
    <pre><code><?php echo htmlspecialchars($info['prefix']); ?></code></pre>
    
    <h4>Check Status:</h4>
    <pre><code><?php echo htmlspecialchars($info['prefix']); ?> -status</code></pre>
    
    <h4>View Help:</h4>
    <pre><code><?php echo htmlspecialchars($info['prefix']); ?> -help</code></pre>
    
    <hr>
<?php endforeach; ?>

<h2>Special Commands</h2>

<h3>cPanel FleetSSL</h3>
<p>Activate FleetSSL with your cPanel license:</p>
<pre><code><?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?> -fleetssl</code></pre>

<h3>cPanel License Verification</h3>
<p>Verify your cPanel license at verify.cpanel.net:</p>
<pre><code>touch /etc/.verifylicense ; <?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<h2>Batch Operations</h2>

<h3>Update All Licenses</h3>
<p>Create a script to update all licenses:</p>
<pre><code>#!/bin/bash

# Update all licenses
<?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?>
<?php echo htmlspecialchars($licenseTypes['liteSpeed']['prefix']); ?>
<?php echo htmlspecialchars($licenseTypes['cloudLinux']['prefix']); ?>
<?php echo htmlspecialchars($licenseTypes['imunify360']['prefix']); ?>

echo "All licenses updated!"</code></pre>

<h3>Check All License Status</h3>
<p>Script to check all license statuses:</p>
<pre><code>#!/bin/bash

echo "=== License Status Report ==="
echo ""
echo "cPanel:"
<?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?> -status
echo ""
echo "LiteSpeed:"
<?php echo htmlspecialchars($licenseTypes['liteSpeed']['prefix']); ?> -status
echo ""
echo "CloudLinux:"
<?php echo htmlspecialchars($licenseTypes['cloudLinux']['prefix']); ?> -status</code></pre>

<h2>Troubleshooting Commands</h2>

<h3>Verify Installation</h3>
<p>Check if license is properly installed:</p>
<pre><code>which <?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?>
ls -la /usr/local/bin/ | grep RcLicense</code></pre>

<h3>Check License Logs</h3>
<p>View license operation logs:</p>
<pre><code>tail -f /var/log/license.log
tail -f /var/log/messages | grep RcLicense</code></pre>

<h3>Reinstall License</h3>
<p>If license command is missing, reinstall it:</p>
<pre><code>bash &lt;( curl <?php echo htmlspecialchars($mirrorUrl); ?>/pre.sh ) cPanel; <?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<h2>Command Output Examples</h2>

<h3>Successful License Status</h3>
<pre><code>License Status Report
=====================
Status: Active
Type: cPanel
Expires: 2025-12-31
Server IP: 192.168.1.1
Hostname: server.example.com
Last Updated: 2025-01-18 12:00:00
Next Check: 2025-01-19 12:00:00</code></pre>

<h3>Expired License</h3>
<pre><code>License Status Report
=====================
Status: EXPIRED
Type: cPanel
Expired: 2024-12-31
Server IP: 192.168.1.1
Hostname: server.example.com

WARNING: Your license has expired!
Please renew your license to continue using this service.</code></pre>

<h2>Scheduling Automatic Updates</h2>

<h3>Cron Job for Daily Updates</h3>
<p>Add to crontab to update licenses daily:</p>
<pre><code>0 2 * * * <?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?> >> /var/log/license-update.log 2>&1</code></pre>

<h3>Cron Job for Weekly Status Check</h3>
<pre><code>0 3 * * 0 <?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?> -status >> /var/log/license-status.log 2>&1</code></pre>

<h2>Quick Reference Table</h2>

<table>
    <thead>
        <tr>
            <th>License Type</th>
            <th>Command</th>
            <th>Installation Script</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($licenseTypes as $type => $info): ?>
            <tr>
                <td><?php echo htmlspecialchars($info['description']); ?></td>
                <td><code><?php echo htmlspecialchars($info['prefix']); ?></code></td>
                <td><?php echo htmlspecialchars($info['script']); ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<h2>Additional Resources</h2>

<ul>
    <li><a href="?page=installation">Installation Guide</a></li>
    <li><a href="?page=troubleshoot">Troubleshooting Guide</a></li>
    <li><a href="?page=faq">FAQ</a></li>
    <li><a href="?page=api">API Documentation</a></li>
</ul>

<?php include '../includes/footer.php'; ?>
