<?php
$pageTitle = 'License Troubleshoot';
include '../includes/config.php';
include '../includes/header.php';
?>

<h1>License Troubleshoot <span class="new-badge" style="display: inline-block;">NEW</span></h1>

<h2>Overview</h2>
<p>This guide helps you troubleshoot common licensing issues. Follow the steps below to diagnose and resolve problems with your RC License installation.</p>

<h2>Pre-Troubleshooting Checklist</h2>

<ul>
    <li>☐ You have root access to your server</li>
    <li>☐ Your server has internet connectivity</li>
    <li>☐ Your operating system is supported</li>
    <li>☐ You have a valid license</li>
    <li>☐ Ports 80 and 443 are not blocked</li>
</ul>

<h2>Common Issues and Solutions</h2>

<h3>License Installation Failed</h3>

<h4>Symptoms:</h4>
<ul>
    <li>Installation script exits with errors</li>
    <li>License command not found after installation</li>
    <li>Permission denied errors</li>
</ul>

<h4>Solutions:</h4>

<p><strong>1. Verify you're running as root:</strong></p>
<pre><code>whoami</code></pre>
<p>Output should be: <code>root</code></p>

<p><strong>2. Check internet connectivity:</strong></p>
<pre><code>curl -I <?php echo htmlspecialchars($mirrorUrl); ?></code></pre>
<p>Should return HTTP 200 or 301 response</p>

<p><strong>3. Reinstall the license:</strong></p>
<pre><code>bash &lt;( curl <?php echo htmlspecialchars($mirrorUrl); ?>/pre.sh ) cPanel; <?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<h3>License Command Not Found</h3>

<h4>Symptoms:</h4>
<ul>
    <li>Command not found error when running license command</li>
    <li>License prefix not recognized</li>
</ul>

<h4>Solutions:</h4>

<p><strong>1. Check if license is installed:</strong></p>
<pre><code>which <?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<p><strong>2. Verify installation path:</strong></p>
<pre><code>ls -la /usr/local/bin/ | grep RcLicense</code></pre>

<p><strong>3. Reinstall if missing:</strong></p>
<pre><code>bash &lt;( curl <?php echo htmlspecialchars($mirrorUrl); ?>/pre.sh ) cPanel; <?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<h3>License Expired</h3>

<h4>Symptoms:</h4>
<ul>
    <li>License status shows "Expired"</li>
    <li>Services restricted or disabled</li>
    <li>Warning messages in logs</li>
</ul>

<h4>Solutions:</h4>

<p><strong>1. Check license status:</strong></p>
<pre><code><?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<p><strong>2. Renew your license:</strong></p>
<p>Contact support or visit our website to renew your license.</p>

<p><strong>3. Update license after renewal:</strong></p>
<pre><code><?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<h3>Network Connectivity Issues</h3>

<h4>Symptoms:</h4>
<ul>
    <li>Cannot download installation files</li>
    <li>Mirror URL not accessible</li>
    <li>Timeout errors</li>
</ul>

<h4>Solutions:</h4>

<p><strong>1. Test connectivity to mirror:</strong></p>
<pre><code>ping <?php echo htmlspecialchars($mirrorUrl); ?>
curl -v <?php echo htmlspecialchars($mirrorUrl); ?></code></pre>

<p><strong>2. Check firewall rules:</strong></p>
<pre><code>iptables -L -n | grep 80
iptables -L -n | grep 443</code></pre>

<p><strong>3. Verify DNS resolution:</strong></p>
<pre><code>nslookup mirror.resellercenter.ir
dig mirror.resellercenter.ir</code></pre>

<h3>Permission Denied Errors</h3>

<h4>Symptoms:</h4>
<ul>
    <li>Permission denied when running license commands</li>
    <li>Cannot write to installation directory</li>
</ul>

<h4>Solutions:</h4>

<p><strong>1. Check file permissions:</strong></p>
<pre><code>ls -la /usr/local/bin/<?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<p><strong>2. Fix permissions:</strong></p>
<pre><code>chmod 755 /usr/local/bin/<?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<p><strong>3. Verify ownership:</strong></p>
<pre><code>chown root:root /usr/local/bin/<?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<h3>License Verification Failed</h3>

<h4>Symptoms:</h4>
<ul>
    <li>Verification command fails</li>
    <li>Cannot connect to verify.cpanel.net</li>
</ul>

<h4>Solutions:</h4>

<p><strong>1. Check cPanel verification status:</strong></p>
<pre><code>touch /etc/.verifylicense
<?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<p><strong>2. Verify network access:</strong></p>
<pre><code>curl -I https://verify.cpanel.net</code></pre>

<p><strong>3. Check firewall rules for outbound connections:</strong></p>
<pre><code>iptables -L -n | grep ACCEPT</code></pre>

<h2>Advanced Troubleshooting</h2>

<h3>Checking System Logs</h3>

<p><strong>View system messages:</strong></p>
<pre><code>tail -f /var/log/messages</code></pre>

<p><strong>Check cPanel logs:</strong></p>
<pre><code>tail -f /var/log/cpanel/error_log</code></pre>

<h3>Testing License Manually</h3>

<p><strong>1. Download installation script:</strong></p>
<pre><code>wget <?php echo htmlspecialchars($mirrorUrl); ?>/pre.sh</code></pre>

<p><strong>2. Run with debug mode:</strong></p>
<pre><code>bash -x pre.sh cPanel</code></pre>

<h3>Collecting Diagnostic Information</h3>

<p>For support, gather this information:</p>
<pre><code>uname -a
php --version
<?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?>
df -h
free -h
ifconfig</code></pre>

<h2>Getting Help</h2>

<h3>Support Resources</h3>
<ul>
    <li><a href="?page=faq">FAQ Page</a></li>
    <li><a href="?page=installation">Installation Guide</a></li>
    <li><a href="https://license.cheap" target="_blank">Main Website</a></li>
    <li><a href="https://status.license.cheap" target="_blank">Status Page</a></li>
</ul>

<h3>Contact Support</h3>
<p>If you cannot resolve the issue, please contact our support team with:</p>
<ul>
    <li>Your license type and ID</li>
    <li>Server OS and version</li>
    <li>Error messages</li>
    <li>Steps you've already tried</li>
    <li>System diagnostic output</li>
</ul>

<?php include '../includes/footer.php'; ?>
