<?php
$pageTitle = 'Setup WHMCS Module';
include '../includes/config.php';
include '../includes/header.php';
?>

<h1>Setup WHMCS Module</h1>

<h2>Overview</h2>
<p>This guide explains how to set up and configure the RC Licensing System WHMCS module for automated license provisioning and management.</p>

<h2>Requirements</h2>

<ul>
    <li>WHMCS 7.0 or higher</li>
    <li>PHP 7.2 or higher</li>
    <li>cURL extension enabled</li>
    <li>Valid RC License account</li>
    <li>API key from RC Licensing System</li>
</ul>

<h2>Installation Steps</h2>

<h3>Step 1: Download the Module</h3>
<p>Download the latest WHMCS License module from your account dashboard.</p>

<h3>Step 2: Extract Files</h3>
<p>Extract the downloaded file to your WHMCS installation directory:</p>
<pre><code>unzip WHMCSLicense.zip
cp License.php YOUR-WHMCS-PATH/vendor/whmcs/whmcs-foundation/lib/License.php</code></pre>

<h3>Step 3: Set File Permissions</h3>
<pre><code>chmod 644 YOUR-WHMCS-PATH/vendor/whmcs/whmcs-foundation/lib/License.php
chown nobody:nobody YOUR-WHMCS-PATH/vendor/whmcs/whmcs-foundation/lib/License.php</code></pre>

<h3>Step 4: Update WHMCS Configuration</h3>
<p>Edit your WHMCS configuration file and add:</p>
<pre><code>define('RC_LICENSE_API_KEY', 'YOUR_API_KEY');
define('RC_LICENSE_MIRROR_URL', '<?php echo htmlspecialchars($mirrorUrl); ?>');</code></pre>

<h3>Step 5: Clear Cache</h3>
<p>Clear WHMCS cache to load the new module:</p>
<pre><code>rm -rf YOUR-WHMCS-PATH/templates_c/*
rm -rf YOUR-WHMCS-PATH/downloads/cache/*</code></pre>

<h2>Configuration</h2>

<h3>Module Settings</h3>
<p>Navigate to Setup → Products/Services → Module Settings and configure:</p>

<table>
    <thead>
        <tr>
            <th>Setting</th>
            <th>Description</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>API Key</td>
            <td>Your RC Licensing System API key</td>
        </tr>
        <tr>
            <td>Mirror URL</td>
            <td><?php echo htmlspecialchars($mirrorUrl); ?></td>
        </tr>
        <tr>
            <td>Auto Provision</td>
            <td>Enable automatic license provisioning</td>
        </tr>
        <tr>
            <td>Auto Suspend</td>
            <td>Automatically suspend expired licenses</td>
        </tr>
        <tr>
            <td>Auto Terminate</td>
            <td>Automatically terminate canceled licenses</td>
        </tr>
    </tbody>
</table>

<h3>Product Configuration</h3>

<h4>Creating License Products</h4>
<p>Create products for each license type:</p>

<ol>
    <li>Go to Setup → Products/Services → Products/Services</li>
    <li>Click "Create a New Product"</li>
    <li>Select "Other" as the product type</li>
    <li>Fill in product details:
        <ul>
            <li><strong>Product Name:</strong> cPanel License</li>
            <li><strong>Product Type:</strong> License</li>
            <li><strong>Module:</strong> RC Licensing</li>
        </ul>
    </li>
    <li>Configure pricing and billing cycles</li>
    <li>Save the product</li>
</ol>

<h4>Configurable Options</h4>
<p>Add configurable options for license selection:</p>

<pre><code>Option Name: License Type
Option Type: Dropdown

Values:
- cPanel
- LiteSpeed
- CloudLinux
- Imunify360
- WordPress
- Softaculous</code></pre>

<h2>Automation Rules</h2>

<h3>Setting Up Automation</h3>

<h4>Auto Provision</h4>
<p>Automatically provision licenses when orders are paid:</p>

<ol>
    <li>Go to Automation → Provisioning</li>
    <li>Create new rule for license products</li>
    <li>Set trigger: "When order is paid"</li>
    <li>Set action: "Provision service"</li>
</ol>

<h4>Auto Suspend</h4>
<p>Automatically suspend licenses when they expire:</p>

<ol>
    <li>Go to Automation → Suspension</li>
    <li>Create new rule</li>
    <li>Set trigger: "When service expires"</li>
    <li>Set action: "Suspend service"</li>
</ol>

<h4>Auto Terminate</h4>
<p>Automatically terminate canceled licenses:</p>

<ol>
    <li>Go to Automation → Termination</li>
    <li>Create new rule</li>
    <li>Set trigger: "When service is canceled"</li>
    <li>Set action: "Terminate service"</li>
</ol>

<h2>Client Portal Integration</h2>

<h3>License Management</h3>
<p>Clients can manage their licenses through the WHMCS client portal:</p>

<ul>
    <li>View license status</li>
    <li>Download license files</li>
    <li>View installation commands</li>
    <li>Request license renewal</li>
</ul>

<h3>Custom Client Area Template</h3>
<p>Customize the client area to display license information:</p>

<pre><code>&lt;?php
if ($service['status'] == 'Active') {
    echo 'License Status: Active';
    echo 'Installation Command: ' . $service['customfields']['install_command'];
}
?&gt;</code></pre>

<h2>Troubleshooting</h2>

<h3>Module Not Loading</h3>

<p><strong>Issue:</strong> Module doesn't appear in product configuration</p>

<p><strong>Solution:</strong></p>
<ul>
    <li>Verify License.php is in correct directory</li>
    <li>Check file permissions (644)</li>
    <li>Clear WHMCS cache</li>
    <li>Verify PHP version compatibility</li>
</ul>

<h3>Provisioning Fails</h3>

<p><strong>Issue:</strong> Licenses not provisioning automatically</p>

<p><strong>Solution:</strong></p>
<ul>
    <li>Verify API key is correct</li>
    <li>Check automation rules are enabled</li>
    <li>Review WHMCS error logs</li>
    <li>Test API connectivity manually</li>
</ul>

<h3>API Connection Error</h3>

<p><strong>Issue:</strong> Cannot connect to licensing API</p>

<p><strong>Solution:</strong></p>
<ul>
    <li>Verify mirror URL is accessible</li>
    <li>Check firewall rules</li>
    <li>Verify cURL is enabled</li>
    <li>Test connectivity: <code>curl -I <?php echo htmlspecialchars($mirrorUrl); ?></code></li>
</ul>

<h2>Advanced Configuration</h2>

<h3>Custom Hooks</h3>
<p>Create custom hooks for additional functionality:</p>

<pre><code>&lt;?php
add_hook('LicenseProvisioned', 1, function($vars) {
    // Custom code after license provisioning
    sendCustomNotification($vars);
});
?&gt;</code></pre>

<h3>API Integration</h3>
<p>Use the WHMCS API to manage licenses programmatically:</p>

<pre><code>&lt;?php
$command = 'GetClientsProducts';
$postData = array(
    'clientid' => 123,
    'status' => 'Active'
);
$results = localAPI($command, $postData);
?&gt;</code></pre>

<h2>Best Practices</h2>

<ul>
    <li>Keep the module updated to the latest version</li>
    <li>Regularly backup your WHMCS database</li>
    <li>Test automation rules in a staging environment first</li>
    <li>Monitor provisioning logs regularly</li>
    <li>Use strong API keys and rotate them periodically</li>
    <li>Document custom configurations</li>
</ul>

<h2>Support</h2>

<p>For WHMCS module support, please contact us through our website or check the <a href="?page=api">API documentation</a>.</p>

<?php include '../includes/footer.php'; ?>
